#include <iostream>
#include <algorithm>
#include <cmath>

using namespace std;

int najveciKrug(int N, int snage[], int Q, pair<int, int> opcije[]) {
    int maksimalniKrug = 0;
    for (int i = 0; i < Q; ++i) {
        int Mi = opcije[i].first - 1;
        int Ji = opcije[i].second;

        int ostvareniKrugovi = 0;
        int preostalo = N;
        int offset = 0;

        while (preostalo > 1) {
            if (Mi >= offset && Mi < offset + preostalo) {
                Mi -= offset;
                int protivnik = (Mi % 2 == 0) ? Mi + 1 : Mi - 1;

                if (snage[protivnik] > snage[Mi]) {
                    Mi = protivnik;
                }

                ostvareniKrugovi++;
                preostalo /= 2;
                offset += preostalo;
            } else {
                preostalo /= 2;
                offset += preostalo;
            }
        }

        if (ostvareniKrugovi >= Ji) {
            maksimalniKrug = max(maksimalniKrug, Ji);
        } else {
            maksimalniKrug = max(maksimalniKrug, ostvareniKrugovi);
        }
    }
    return maksimalniKrug;
}

int main() {
    int N, Q;
    cin >> N;

    int snage[N];
    for (int i = 0; i < N; ++i) {
        cin >> snage[i];
    }

    cin >> Q;

    pair<int, int> opcije[Q];
    for (int i = 0; i < Q; ++i) {
        cin >> opcije[i].first >> opcije[i].second;
    }

    int rezultat = najveciKrug(N, snage, Q, opcije);
    cout << rezultat << endl;

    return 0;
}